<?php
/**
* @version $Id: myjspace.mod.class.php 0.10.0 03-10-2007 $ 
* @package myjspace
* @copyright (C) 2007 D'Abronzo Vincenzo
* @license GNU / GPL
* @author D'Abronzo Vincenzo
* MyJSpace is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// no direct access
defined( '_MJSEXEC' ) or die( 'Restricted access' );

require_once( dirname(__FILE__).DS.'viewmjspages.mod.vocabulary.php' );

class MJS_Mod_ViewMJSPages {
	var $foldername;

	var $db;
	var $pages = array();
	
	function mjs_mod_viewmjspages() {
	}

	function show() {
		if( !$this->loadConfig() ) {
			echo ViewMJSPages_Vocabulary::echoErrLoadingConfig();
		} else if( $this->loadPages() ) {
			$host  = $_SERVER['HTTP_HOST'];
			$uri   = rtrim(dirname($_SERVER['PHP_SELF']), DS);
			for($i=0; $i<count($this->pages); $i++) {
				$url = "http://".$host.$uri.DS.$this->foldername.DS.$this->pages[$i];
				echo '<a href="'.$url.'">';
				echo $this->pages[$i];
				echo '</a><br />';
			} 
		} else echo ViewMJSPages_Vocabulary::echoNoPages();
	}

	function loadConfig() {
		$query = "SELECT * FROM #__myjspace_cfg";
		$this->db->setQuery($query);
		$result_set = $this->db->loadObjectList();
		if( $result_set != null ) {
			foreach( $result_set as $result) {
				$this->foldername = $result->foldername;
			}
			return 1;
		}
		return 0;		
	}

	function loadPages() {
		$query = "SELECT * FROM #__myjspace mjs LEFT JOIN #__users jos ON mjs.id=jos.id";
		$this->db->setQuery($query);
		$result_set = $this->db->loadObjectList();
		if( $result_set != null ) {
			$i = 0;
			foreach( $result_set as $result) {
				$this->pages[] = $result->pagename;
				$i++;
			}
			return $i;
		}
		return 0;
	}

	function setDatabase($db) {
		$this->db = $db;
	}
}
