<?php
/**
* @version $Id: myjspace.com.html.php $ 
* @package myjspace
* @copyright (C) 2007 D'Abronzo Vincenzo
* @license GNU / GPL
* @author D'Abronzo Vincenzo
* MyJSpace is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// no direct access
defined( '_MJSEXEC' ) or die( 'Restricted access' );

require_once( dirname(__FILE__).DS.'myjspace.com.vocabulary.php' );

class MJS_HTML {
	function showNewPage() {
		echo MJS_Com_Vocabulary::echoInsertPagename();
		?>
		<form method="post" action="index.php?option=com_myjspace&amp;task=new_page">
			<input type="text" name="mjs_pagename" />
			<div id="newpage_okbutton"><input type="submit" value="<?php echo MJS_Com_Vocabulary::echoSave(); ?>" /></div>
		</form>
		<?php
	}

	function showRenamePage() {
		echo MJS_Com_Vocabulary::echoInsertPagename();
		?>
		<form method="post" action="index.php?option=com_myjspace&amp;task=ren_page">
			<input type="text" name="mjs_pagename" />
			<div id="renpage_okbutton"><input type="submit" value="<?php echo MJS_Com_Vocabulary::echoSave(); ?>" /></div>
		</form>
		<?php
	}

	function showEditor($content) {
		$host  = $_SERVER['HTTP_HOST'];
		$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
		$editorpath = "http://".$host.$uri.DS."components".DS."com_myjspace".DS."editor".DS."tinymce".DS."tiny_mce.js";
		echo '<script language="javascript" type="text/javascript" src="'.$editorpath.'"></script>
<script language="javascript" type="text/javascript" id="tinyMCE">
	tinyMCE.init({
	mode: "textareas",
	language: "en",
	plugins: "advimage, advlink, contextmenu, layer, media, searchreplace, style, table",
	theme_advanced_buttons1: "bold, italic, underline, strikethrough, cut, copy, paste, fontsizeselect, justifyleft, justifycenter, justifyright, justifyfull, bullist, numlist, charmap",
	theme_advanced_buttons2: "forecolor, backcolor, styleprops, indent, outdent, replace, search, link, unlink, code, removeformat, cleanup, image, media, undo, redo",
	theme_advanced_buttons3: "tablecontrols, separator,insertlayer,moveforward,movebackward,absolute",
	theme_advanced_toolbar_location: "top",
	theme_advanced_toolbar_align: "left",
	theme_advanced_path_location: "bottom",
	theme_advanced_resizing: true
	});
</script>';
		?>
		<form method="post" action="index.php?option=com_myjspace&amp;task=update_page">
			<textarea rows="20" cols="60" name="mjs_content"><?php echo $content; ?></textarea>
			<br />
			<br />
			<div id="editor_okbutton"><input type="submit" value="<?php echo MJS_Com_Vocabulary::echoSave(); ?>" /></div>
		</form>
		<?php
	}

	function showDelConfirmDialog() {
		echo MJS_Com_Vocabulary::echoAreYouSure();
		?>
		<form method="post" action="index.php?option=com_myjspace&amp;task=del_page&amp;mjs_deletepage=1">
			<div id="editor_okbutton"><input type="submit" value="<?php echo MJS_Com_Vocabulary::echoYes(); ?>" /></div>
		</form>
		<?php
		
	}
}
