<?php
/**
* @version $Id: myjspace.admin.com.html.php $ 
* @package myjspace
* @copyright (C) 2007 D'Abronzo Vincenzo
* @license GNU / GPL
* @author D'Abronzo Vincenzo
* MyJSpace is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// no direct access
defined( '_MJSEXEC' ) or die( 'Restricted access' );
require_once( MYJROOTDIR.DS."components".DS."com_myjspace".DS.'myjspace.class.php' );

class HTML_myjspace {
	function showConfigForm( $adminindex, $foldername ) {
		?>
		<form method="POST" action="<?php echo $adminindex; ?>?option=com_myjspace&task=save_config">
			<input type="text" name="mjs_foldername" value="<?php echo $foldername; ?>" />
			<input type="submit" value="<?php echo MJS_Com_Vocabulary::echoSave(); ?>" />
		</form>
		<?php
	}

	function showConfirmDialog($task, $id) {
		echo MJS_Com_Vocabulary::echoAreYouSure();
		?>
		<form method="post" action="<?php echo $adminindex; ?>?option=com_myjspace&amp;id=<?php echo $id; ?>&amp;task=<?php echo $task; ?>&amp;mjs_dotask=1">
			<div id="dotask_okbutton"><input type="submit" value="<?php echo MJS_Com_Vocabulary::echoYes(); ?>" /></div>
		</form>
		<?php
	}
	
	function showUsers( $adminindex, $foldername, $dbo ) {
		$mjscom = new MJS_Component;
		
		$query = "SELECT * FROM #__myjspace mjs LEFT JOIN #__users jos ON mjs.id=jos.id";
		$dbo->setQuery($query);
		$result_set = $dbo->loadObjectList();
		if( $result_set != null ) {
			echo "<table cellpadding=\"5\"><tbody>";	
			echo "<tr align=\"center\">
					<td><b>".MJS_Com_Vocabulary::echoId()."</b></td>
					<td><b>".MJS_Com_Vocabulary::echoName()."</b></td>
					<td><b>".MJS_Com_Vocabulary::echoUsername()."</b></td>
					<td><b>".MJS_Com_Vocabulary::echoPagename()."</b></td>
					<td><b>".MJS_Com_Vocabulary::echoBlockEdit()."</b></td>
					<td><b>".MJS_Com_Vocabulary::echoBlockView()."</b></td>
					<td colspan=\"2\"><b>".MJS_Com_Vocabulary::echoOption()."</b></td>
				</tr>";
			foreach( $result_set as $result ) {
				$host = $_SERVER['HTTP_HOST'];
				$uri = rtrim(dirname($_SERVER['PHP_SELF']), DS);
				$path = explode( DS, $uri );
				array_pop($path);
				$uri = implode( DS, $path );
				$url = "http://".$host.$uri.DS.$foldername.DS.$result->pagename;
				echo "<tr>";
					echo "<td>".$result->id."</td>";
					echo "<td>".$result->name."</td>";
					echo "<td>".$result->username."</td>";
					echo "<td><a href=\"$url\" target=\"_blank\">".$result->pagename."</a></td>";
					if( $result->blockEdit ) echo "<td><font color=\"red\"><b>".MJS_Com_Vocabulary::echoYes()."</b></font></td>";
					else echo "<td>".MJS_Com_Vocabulary::echoNo()."</td>";
					if( $result->blockView ) echo "<td>".MJS_Com_Vocabulary::echoYes()."</td>";
					else echo "<td>".MJS_Com_Vocabulary::echoNo()."</td>";
					echo "<td><a href=\"$adminindex?option=com_myjspace&task=edit_user&id=$result->id\"><b>".MJS_Com_Vocabulary::echoEdit()."</b></a></td>";
					echo "<td><a href=\"$adminindex?option=com_myjspace&task=del_page&id=$result->id\"><b>".MJS_Com_Vocabulary::echoDelete()."</b></a></td>";
				echo "</tr>";
			}
			echo "</tbody></table>";
			return 1;
		} else echo MJS_Com_Vocabulary::echoNoUsers();
	}
	function showUser( $adminindex, $dbo, $id ) {
		$mjscom = new MJS_Component;
		$mjscom->setUserId($id);
		$mjscom->setDatabase($dbo);
		$mjscom->loadUserInfo();
		if( $mjscom->getblockEdit() ) $checkedit = 'checked="checked"';
		if( $mjscom->getblockView() ) $checkview = 'checked="checked"';

		?>
		<table>
		<tbody>
		<form method="POST" action="<?php echo $adminindex; ?>?option=com_myjspace&task=save_user">
			<?php echo MJS_Com_Vocabulary::echoId(); ?><br />
			<input type="text" name="id" readonly="readonly" value="<?php echo $id; ?>" />
			<br /><?php echo MJS_Com_Vocabulary::echoPagename(); ?><br />
			<input type="text" name="pagename" readonly="readonly" value="<?php echo $mjscom->getPagename(); ?>" />
			<br />
		<?php
			echo MJS_Com_Vocabulary::echoBlockEdit()."<input type=\"checkbox\" name=\"blockEdit\" ".$checkedit." /><br />";
			echo MJS_Com_Vocabulary::echoBlockView()."<input type=\"checkbox\" name=\"blockView\" ".$checkview." /><br />";

			// TinyMCE Editor
			$host  = $_SERVER['HTTP_HOST'];
			$uri   = rtrim(dirname($_SERVER['PHP_SELF']), '/\\');
			$path = explode(DS, $uri);
			array_pop($path);
			$uri = implode(DS, $path);
			$uri   = rtrim($uri, '/\\');
			$editorpath = "http://".$host.$uri.DS."components".DS."com_myjspace".DS."editor".DS."tinymce".DS."tiny_mce.js";
			echo '<script language="javascript" type="text/javascript" src="'.$editorpath.'"></script>
<script language="javascript" type="text/javascript" id="tinyMCE">
	tinyMCE.init({
	mode: "textareas",
	language: "en",
	plugins: "advimage, advlink, contextmenu, layer, media, searchreplace, style, table",
	theme_advanced_buttons1: "bold, italic, underline, strikethrough, cut, copy, paste, fontsizeselect, justifyleft, justifycenter, justifyright, justifyfull, bullist, numlist, charmap",
	theme_advanced_buttons2: "forecolor, backcolor, styleprops, indent, outdent, replace, search, link, unlink, code, removeformat, cleanup, image, media, undo, redo",
	theme_advanced_buttons3: "tablecontrols, separator,insertlayer,moveforward,movebackward,absolute",
	theme_advanced_toolbar_location: "top",
	theme_advanced_toolbar_align: "left",
	theme_advanced_path_location: "bottom",
	theme_advanced_resizing: true
	});
</script>';
			echo "<br /><br /><textarea name=\"mjs_content\" rows=\"20\" cols=\"60\" >".$mjscom->getContent()."</textarea><br />";
		?>
			<br /><input type="submit" value="<?php echo MJS_Com_Vocabulary::echoSave(); ?>" />
		</form>
		</tbody>
		</table>
		<?php
	}
}
