<?php
/**
* @version $Id: myjspace.com.class.php $ 
* @package myjspace
* @copyright (C) 2007 D'Abronzo Vincenzo
* @license GNU / GPL
* @author D'Abronzo Vincenzo
* MyJSpace is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// no direct access
defined( '_MJSEXEC' ) or die( 'Restricted access' );

require_once( dirname(__FILE__).DS.'myjspace.com.vocabulary.php' );
require_once( dirname(__FILE__).DS.'myjspace.com.html.php' );

class MJS_Component {
	var $task;
	var $userid;
	var $pagename;
	var $content;
	var $blockEdit;
	var $blockView;
	var $foldername;

	var $postedpagecontent;

	var $db;
	var $rootdir;

	/**
	 * Constructor
	 *
	 */
	function mjs_component() {
	}

	function doTask() {
		$mjs_error = $_GET['mjs_error'];

		if( $mjs_error != null ) {
			// NUP - Not Unique Pagename
			if($mjs_error == "nup")  $this->viewWarning( MJS_Com_Vocabulary::echoNotUniquePagename() );
			// NVP - Not Valid Pagename
			else if($mjs_error == "nvp") $this->viewWarning( MJS_Com_Vocabulary::echoNotValidPagename() );
		}

		if( $this->loadFoldername() ) {
			if( $this->task == "new_page" ) {
				if( $this->userid ) {
					if ( $this->loadUserInfo() ) {
						if( $this->blockEdit ) {
							$this->viewWarning( MJS_Com_Vocabulary::echoEditBlocked() );
							return 1;
						} else {
							$this->viewWarning( MJS_Com_Vocabulary::echoPageAlreadyCreated() );
							return 1;
						}
					} else {
						$pagename = $_POST['mjs_pagename'];
						if( $pagename != null ) $this->createPage($pagename);
						else MJS_HTML::showNewPage();
						return 1;
					}
				} else {
					$this->viewWarning( MJS_Com_Vocabulary::echoPleaseLogin() );
					return 1;
				}
				return 0;
			} else if( $this->task == "view_page" ) {
				$pageid = (int)$_GET["id"];
				$this->setUserId( $pageid );
				if( $this->loadUserInfo() ) {
					if( $this->blockView ) {
						$this->viewWarning( MJS_Com_Vocabulary::echoViewBlocked() );
						return 1;
					} else {
						if( $this->content != null ) echo $this->content;
						else $this->viewWarning( MJS_Com_Vocabulary::echoPageEmpty() );
						return 1;
					}
				} else {
					$this->viewError( MJS_Com_Vocabulary::echoPageNotFound() );
					return 1;
				}
				return 0;
			} else if( $this->task == "view_link" ) {
				if( $this->userid ) {
					if( $this->loadUserInfo() ) {
						if( $this->blockView ) {
							$this->viewWarning( MJS_Com_Vocabulary::echoViewBlocked() );
							return 1;
						} else {
							$host  = $_SERVER['HTTP_HOST'];
							$uri   = rtrim(dirname($_SERVER['PHP_SELF']), DS);
							$url = "http://".$host.$uri.DS.$this->foldername.DS.$this->pagename;
							echo MJS_Com_Vocabulary::echoPageLink().'<a href="'.$url.'">'.$url.'</a>';
						}
					} else {
						$this->viewWarning( MJS_Com_Vocabulary::echoPleaseCreatePage() );
						return 1;
					}
				} else {
					$this->viewWarning( MJS_Com_Vocabulary::echoPleaseLogin() );
					return 1;
				}
				return 0;
			} else if( $this->task == "view_editor" ) {
				if( $this->userid ) {
					if( $this->loadUserInfo() ) {
						if( $this->blockEdit ) {
							$this->viewWarning( MJS_Com_Vocabulary::echoEditBlocked() );
							return 1;
						} else {
							MJS_HTML::showEditor( $this->content );
							return 1;
						}
					} else {
						$this->viewWarning( MJS_Com_Vocabulary::echoPleaseCreatePage() );
						return 1;
					}
				} else {
					$this->viewWarning( MJS_Com_Vocabulary::echoPleaseLogin() );
					return 1;
				}
				return 0;
			} else if( $this->task == "update_page" ) {
				if( $this->userid ) {
					if( $this->loadUserInfo() ) {
						if( $this->blockEdit ) {
							$this->viewWarning( MJS_Com_Vocabulary::echoEditBlocked() );
							return 1;
						} else {
							$this->updateUser();
							return 1;
						}
					} else {
						$this->viewWarning( MJS_Com_Vocabulary::echoPleaseCreatePage() );
						return 1;
					}
				} else {
					$this->viewWarning( MJS_Com_Vocabulary::echoPleaseLogin() );
					return 1;
				}
				return 0;
			} else if( $this->task == "ren_page" ) {
				if( $this->userid ) {
					if( $this->loadUserInfo() ) {
						if( $this->blockEdit ) {
							$this->viewWarning( MJS_Com_Vocabulary::echoEditBlocked() );
							return 1;
						} else {
						$pagename = $_POST['mjs_pagename'];
						if( $pagename != null ) $this->renamePage($pagename);
						else MJS_HTML::showRenamePage();
						return 1;
						}
					} else {
						$this->viewWarning( MJS_Com_Vocabulary::echoPleaseCreatePage() );
						return 1;
					}
				} else {
					$this->viewWarning( MJS_Com_Vocabulary::echoPleaseLogin() );
					return 1;
				}
				return 0;
			} else if( $this->task == "del_page" ) {
				if( $this->userid ) {
					if( $this->loadUserInfo() ) {
						if( $this->blockEdit ) {
							$this->viewWarning( MJS_Com_Vocabulary::echoEditBlocked() );
							return 1;
						} else {
							$doDelete = (int)$_GET["mjs_deletepage"];
							if ( $doDelete ) {
								$this->deletePage();
								return 1;
							} else {
								MJS_HTML::showDelConfirmDialog();
								return 1;
							}
							return 1;
						}
					} else {
						$this->viewWarning( MJS_Com_Vocabulary::echoPleaseCreatePage() );
						return 1;
					}
				} else {
					$this->viewWarning( MJS_Com_Vocabulary::echoPleaseLogin() );
					return 1;
				}
				return 0;
			} else {
				echo MJS_Com_Vocabulary::echoCredits();
				return 0;
			}
		} else $this->viewError( MJS_Com_Vocabulary::echoFolderNotExists( $this->foldername) );
		return 0;
	}

	function loadUserInfo() {
		if($this->userid) {
			$query = "SELECT * FROM #__myjspace WHERE id = '$this->userid'";
			$this->db->setQuery($query);
			$result_set = $this->db->loadObjectList();
			if( $result_set != null ) {
				foreach( $result_set as $result) {
					$this->pagename = $result->pagename;
					$this->content = $result->content;
					$this->blockEdit = $result->blockEdit;
					$this->blockView = $result->blockView;
				}
				return 1;
			}
		}
		return 0;	
	}

	function loadFoldername() {		
		$query = "SELECT * FROM #__myjspace_cfg";
		$this->db->setQuery($query);
		$result_set = $this->db->loadObjectList();
		if( $result_set != null ) {
			foreach( $result_set as $result) {
				$this->foldername = $result->foldername;
				$filepath = $this->rootdir.DS.$this->foldername;
				if ( is_dir($filepath) ) return 1;
			}
		}
		$this->viewError( MJS_Com_Vocabulary::echoErrLoadFolder() );
		return 0;	
	}

	function createPage($pagename) {		
		$pagename = strtolower($pagename);
		if( !$this->checkPagename($pagename) ) {
			return 0;
		}
		$query = "INSERT INTO #__myjspace (`id`, `pagename`, `content`, `blockEdit`, `blockView` ) VALUES ('$this->userid', '$pagename','', '0', '0')";
		$this->db->setQuery($query);
		if ( $this->writePage($pagename) ) {	
			if( $this->db->query() ) {
				echo MJS_Com_Vocabulary::echoPageCreated();
				return 1;
			}
		}
		$this->viewError( MJS_Com_Vocabulary::echoErrCreatePage() );
		return 0;
	}

	function renamePage($newpagename) {		
		$newpagename = strtolower($newpagename);
		if( !$this->checkPagename($newpagename) ) {
			return 0;
		}
		$filepath = $this->rootdir.DS.$this->foldername;
		if( rename($filepath.DS.$this->pagename, $filepath.DS.$newpagename) ) {
			$query = "UPDATE #__myjspace SET `pagename` = '$newpagename' WHERE `id` = '$this->userid'";
			$this->db->setQuery($query);
			if( $this->db->query() ) {
				echo MJS_Com_Vocabulary::echoInformationsUpdated();
				return 1;
			}
		}
		$this->viewError( MJS_Com_Vocabulary::echoErrUpdatingPage() );
		return 0;
	}

	function writePage($pagename) {
		$filedir = $this->rootdir.DS.$this->foldername.DS.$pagename;
		$content = '<?php header("location: ..'.DS.'..'.DS.'index.php?option=com_myjspace&task=view_page&id='.$this->userid.'");';
		if( mkdir($filedir) ) {
			if ( chmod($filedir, 0755) ) {
				// $this->viewWarning( MJS_Com_Vocabulary::echoErrChmod() );
			}
				$file = $filedir.DS."index.php";
				$handle = @fopen($file,"w");
				if($handle) {
					fwrite( $handle, $content, strlen($content) );
					chmod($file, 0755);
					return 1;
				}
		}
		return 0;
	}

	function updateUser() {
		$this->postedpagecontent = str_replace("'", "&#39;", $this->postedpagecontent);
		$query = "UPDATE #__myjspace 
				SET `content` = '$this->postedpagecontent',
				`blockEdit` = '$this->blockEdit',
				`blockView` = '$this->blockView',
				`pagename` = '$this->pagename'
		WHERE `id` = '$this->userid'";
		$this->db->setQuery($query);
		if( $this->db->query() ) {
			echo MJS_Com_Vocabulary::echoInformationsUpdated();
			return 1;
		}
		$this->viewError( MJS_Com_Vocabulary::echoErrUpdatingPage() );
		return 0;
	}

	function updateFoldername( $foldername ) {
		if( $this->checkFoldername( $foldername ) ) {
			$foldername = strtolower( $foldername );
			$query = "UPDATE #__myjspace_cfg SET `foldername` = '$foldername' WHERE `foldername` = '$this->foldername'";
			$this->db->setQuery($query);
			if( $this->db->query() ) {
				echo MJS_Com_Vocabulary::echoFoldernameUpdated();
				return 1;
			}
		}
		$this->viewError( MJS_Com_Vocabulary::echoErrUpdatingFoldername() );
		return 0;
	}

	function checkFoldername( $foldername ) {
		if( ereg("^[A-Za-z0-9]+$", $foldername) ) {
			return 1;
		} else {
			header("Location: index.php?option=com_myjspace&task=show_config&mjs_error=nvf");
		}
		return 0;
	}

	function checkPagename( $pagename ) {
		if( ereg("^[A-Za-z0-9]+$", $pagename) ) {
			if( $this->isUniquePagename($pagename) ) {
				return 1;
			} else header("Location: index.php?option=com_myjspace&task=new_page&mjs_error=nup");
		} else {
			header("Location: index.php?option=com_myjspace&task=new_page&mjs_error=nvp");
		}
		return 0;
	}

	function isUniquePagename($pagename) {
		$this->db->setQuery("SELECT * FROM #__myjspace WHERE pagename = '$pagename'");
		$result_set = $this->db->loadObjectList();
		if( $result_set == null ) return 1;
		return 0;
	}

	function deletePage() {
		$filedir = $this->rootdir.DS.$this->foldername.DS.$this->pagename;
		$file = $filedir.DS."index.php";
		if( is_file($file) ) {
			if ( unlink($file) ) {
				if( is_dir($filedir) ) {
					if( rmdir($filedir) ) {
						$query = "DELETE FROM #__myjspace WHERE id = '$this->userid'";
						$this->db->setQuery($query);
						if( $this->db->query() ) {
							echo MJS_Com_Vocabulary::echoPageDeleted();
							return 1;
						}
					}
				}
			}
		}
		$this->viewError( MJS_Com_Vocabulary::echoErrDeletingPage() );
		return 0;
	}

	function viewError($error) {
		echo MJS_Com_Vocabulary::echoError();
		echo $error."<br />";
	}
	
	function viewWarning($warning) {
		echo MJS_Com_Vocabulary::echoWarning();
		echo $warning."<br />";
	}

	function setBlockEdit($be) {
		$this->blockEdit = $be;
	}

	function setBlockView($bv) {
		$this->blockView = $bv;
	}

	function setDatabase($db) {
		$this->db = $db;
	}

	function setPostedPageContent($ppc) {
		$this->postedpagecontent = $ppc;
	}

	function setRootDir($rootdir) {
		$this->rootdir = $rootdir;
	}

	function setTask($taskname) {
		$this->task = $taskname;
	}

	function setUserId($userid) {
		$this->userid = $userid;
	}

	function getBlockEdit() {
		return isset($this->blockEdit) ? $this->blockEdit : null;
	}
	
	function getBlockView() {
		return isset($this->blockView) ? $this->blockView : null;
	}
	
	function getContent() {
		return isset($this->content) ? $this->content : null;
	}

	function getFoldername() {
		return isset($this->foldername) ? $this->foldername : null;
	}

	function getPagename() {
		return isset($this->pagename) ? $this->pagename : null;
	}

}
