<?php
/**
* @version $Id: myjspace.admin.com.class.php $ 
* @package myjspace
* @copyright (C) 2007 D'Abronzo Vincenzo
* @license GNU / GPL
* @author D'Abronzo Vincenzo
* MyJSpace is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*/

// no direct access
defined( '_MJSEXEC' ) or die( 'Restricted access' );

require_once( MYJROOTDIR.DS."components".DS."com_myjspace".DS.'myjspace.com.vocabulary.php' );
require_once( MYJROOTDIR.DS."components".DS."com_myjspace".DS.'myjspace.class.php' );
require_once( MYJROOTDIR.DS."administrator".DS."components".DS."com_myjspace".DS.'myjspace.admin.html.php' );

class MJS_Admin {
	var $task;
	var $adminindex;

	var $db;
	var $rootdir;

	/**
	 * Constructor
	 *
	 */
	function mjs_component() {
	}

	function doTask() {
		$mjs_error = $_GET['mjs_error'];

		if( $mjs_error != null ) {
			// NVF - Not Valid Foldername
			if($mjs_error == "nvp") $this->viewWarning( MJS_Com_Vocabulary::echoNotValidFoldername() );
		}

		$mjscom = new MJS_Component;
		$mjscom->setDatabase( $this->db );
		$mjscom->setRootDir( $this->rootdir );
		
		echo "MyJSpace<br />".MJS_Com_Vocabulary::echoCredits()."<br /><br />";

		if( $mjscom->loadFoldername() ) {
			if( $this->task == "show_config" ) {
				HTML_myjspace::showConfigForm( $this->adminindex, $mjscom->getFoldername() );
				echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
				return 1;
			} else if( $this->task == "save_config" ){
					$foldername = $_POST["mjs_foldername"];
					$mjscom->updateFoldername( $foldername );
					echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
					return 1;
			} else if( $this->task == "show_users" ) {
				HTML_myjspace::showUsers( $this->adminindex, $mjscom->getFoldername(), $this->db );
				echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
				return 1;
			} else if( $this->task == "edit_user" ) {
				if ( $id = (int)$_GET["id"] ) {
					HTML_myjspace::showUser($this->adminindex, $this->db, $id);
					echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
				} else $mjscom->writeError( MJS_Com_Vocabulary::echoNotValidId() );
				return 1;
			} else if( $this->task == "save_user" ) {
				$id = $_POST["id"];
				$blockEdit = $_POST["blockEdit"];
				$blockView = $_POST["blockView"];
				$content = $_POST["mjs_content"];
				if( $id != null ) {
					if( $blockEdit == "on" ) $blockEdit = 1;
						else $blockEdit = 0;
					if( $blockView == "on" ) $blockView = 1;
						else $blockView = 0;
					$mjscom->setUserId( $id );
					$mjscom->loadUserInfo();
					$mjscom->setBlockEdit( $blockEdit );
					$mjscom->setBlockView( $blockView );
					$mjscom->setPostedPageContent( $content );
					$mjscom->updateUser();
				} else {
					$mjscom->writeError( MJS_Com_Vocabulary::echoCanNotSaveUser() );
				}
				echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
//			} else if( $this->task == "ren_page" ) {
			} else if( $this->task == "del_page" ) {
				if ( $dotask = (int)$_GET["mjs_dotask"] ) {
					if ( $id = (int)$_GET["id"] ) {
						$mjscom->setUserId( $id );
						$mjscom->loadUserInfo();
						if( $mjscom->deletePage() ) {
							echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
							return 1;
						} else echo MJS_Com_Vocabulary::echoErrDeletingPage();
					} else $mjscom->writeError( MJS_Com_Vocabulary::echoNotValidId() );
					echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
				} else if ( $id = (int)$_GET["id"] ) {
					HTML_myjspace::showConfirmDialog("del_page", $id);
					echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
				} else $mjscom->writeError( MJS_Com_Vocabulary::echoNotValidId() );
				return 1;
				echo '<br /><br /><a href="'.$this->adminindex.'?option=com_myjspace">'.MJS_Com_Vocabulary::echoBack().'</a><br />';
			} else {
				echo MJS_Com_Vocabulary::echoComponentConfiguration()."<br />";
				echo '<a href="'.$this->adminindex.'?option=com_myjspace&task=show_config">'.MJS_Com_Vocabulary::echoShowConfiguration().'</a><br />';
				echo '<a href="'.$this->adminindex.'?option=com_myjspace&task=show_users">'.MJS_Com_Vocabulary::echoShowUsers().'</a><br />';
				return 1;
			}
		} else {
			$mjscom->viewError( MJS_Com_Vocabulary::echoFolderNotExists( $mjscom->foldername ) );
			return 1;
		}
		return 0;
	}

	function setDatabase($db) {
		$this->db = $db;
	}

	function setRootDir($rootdir) {
		$this->rootdir = $rootdir;
	}

	function setTask($taskname) {
		$this->task = $taskname;
	}

	function setAdminIndex($indexname) {
		$this->adminindex = $indexname;
	}
}
